#include <bits/stdc++.h>
#define endl '\n'

using namespace std;

int n, k;

int next(int i){
    return (++i >= n ? 0 : i);
}

int prev(int i){
    return (--i < 0 ? n - 1 : i);
}

void recalc(int nearest[], int i){
    int n = i, p = i;
    int dist = 0;
    nearest[i] = 0;

    while(true){ //napred
        n = next(n);
        dist++;

        if(dist >= nearest[n]) break;
        nearest[n] = dist;
    }

    dist = 0;
    while(true){ //nazad
        p = prev(p);
        dist++;

        if(dist >= nearest[p]) break;
        nearest[p] = dist;
    }
}

int findNum(int popul[], int nearest[], int i){
    if(nearest[i] == 0) return 0;

    int o = popul[i];

    int n = i, p = i;
    int dist = 0;
    while(true){ //napred
        n = next(n);
        dist++;

        if(dist > nearest[n]) break;

        if(dist == nearest[n]){
            o += popul[n] / 2;
            break;
        }

        o += popul[n];
    }

    dist = 0;
    while(true){ //nazad
        p = prev(p);
        dist++;

        if(dist > nearest[p]) break;

        if(dist == nearest[p]){
            o += popul[p] / 2;
            break;
        }

        o += popul[p];
    }

    return o;
}

pair<int, int> place(int popul[], int nearest[]){
    int maxN = 0, maxI = 0;
    for(int i = 0; i < n; i++){
        int t = findNum(popul, nearest, i);
        if(t > maxN) {
            maxN = t;
            maxI = i;
        }
    }

    return pair<int, int>(maxN, maxI);
}

int main(){
    ios::sync_with_stdio(false); cin.tie(0);
    cin>>n>>k;

    int shops[k];
    int popul[n];
    int nearest[n];

    for(int i = 0; i < k; i++){
        cin>>shops[i];
    }

    sort(shops, shops + k);

    int totalPopul = 0;
    int maxPossible = 0;
    for(int i = 0; i < n; i++){
        cin>>popul[i];
        totalPopul += popul[i];

        int num = i + 1; //broj grada
        int index = upper_bound(shops, shops + k, num) - shops;

        if(index == k){
            nearest[i] = num - shops[k - 1];
        }else if(index < 1){
            nearest[i] = abs(num - shops[index]);
        }else{
            nearest[i] = min(abs(num - shops[index]), abs(num - shops[index - 1]));
        }

        int nearestBack = abs(num + n - shops[k - 1]);
        if(nearestBack < nearest[i]) nearest[i] = nearestBack;

        if(nearest[i] > 0) {
            maxPossible += popul[i];
        }
    }

    int reqPopul = totalPopul / 2;
    if(maxPossible < reqPopul) {
        cout<<"-1";
        return 0;
    }

    int current = 0, newShops = 0;;
    while(current <= reqPopul){
        pair<int, int> l = place(popul, nearest);
        current += l.first;
        newShops++;

        if(current > reqPopul){
            cout<<newShops;
            return 0;
        }

        recalc(nearest, l.second);
    }

    return 0;
}